/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Blueprint {
    private static final String ENTITY_POS = "Pos";
    private final List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private List<BlockState> palette;
    private String name;
    private String[] architects;
    private String[] missingMods;
    private short[][][] structure;
    private CompoundTag[][][] tileEntities;
    private CompoundTag[] entities = new CompoundTag[0];
    private List<BlockInfo> cacheBlockInfo = null;
    private Map<BlockPos, BlockInfo> cacheBlockInfoMap = null;
    private Map<BlockPos, CompoundTag[]> cacheEntitiesMap = null;
    private BlockPos cachePrimaryOffset = null;
    private BlockPos renderSource = BlockPos.f_121853_;

    public Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, List<BlockState> pallete, short[][][] structure, CompoundTag[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.palette = pallete;
        this.structure = structure;
        this.tileEntities = new CompoundTag[sizeY][sizeZ][sizeX];
        for (CompoundTag te : tileEntities) {
            if (te == null) continue;
            this.tileEntities[te.m_128448_((String)"y")][te.m_128448_((String)"z")][te.m_128448_((String)"x")] = te;
        }
        this.requiredMods = requiredMods;
    }

    public Blueprint(short sizeX, short sizeY, short sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.structure = new short[sizeY][sizeZ][sizeX];
        this.tileEntities = new CompoundTag[sizeY][sizeZ][sizeX];
        this.requiredMods = new ArrayList<String>();
        this.palette = new ArrayList<BlockState>();
        this.palette.add(0, ((BlockSubstitution)((Object)ModBlocks.blockSubstitution.get())).m_49966_());
        this.palleteSize = 1;
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public BlockState[] getPalette() {
        return this.palette.toArray(new BlockState[0]);
    }

    public void addBlockState(BlockPos pos, BlockState state) {
        int index = -1;
        for (int i = 0; i < this.palette.size(); ++i) {
            if (!this.palette.get(i).equals(state)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = this.palleteSize;
            this.palleteSize = (short)(this.palleteSize + 1);
            this.palette.add(state);
        }
        this.structure[pos.m_123342_()][pos.m_123343_()][pos.m_123341_()] = (short)index;
        this.cacheReset(true);
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public CompoundTag[][][] getTileEntities() {
        return this.tileEntities;
    }

    public CompoundTag[] getEntities() {
        return this.entities;
    }

    public void setEntities(CompoundTag[] entities) {
        this.entities = entities;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public String getName() {
        return this.name;
    }

    public Blueprint setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public void setArchitects(String[] architects) {
        this.architects = architects;
    }

    public String[] getMissingMods() {
        return this.missingMods;
    }

    public Blueprint setMissingMods(String ... missingMods) {
        this.missingMods = missingMods;
        return this;
    }

    public final List<CompoundTag> getEntitiesAsList() {
        return Arrays.stream(this.entities).collect(Collectors.toList());
    }

    public final List<BlockInfo> getBlockInfoAsList() {
        if (this.cacheBlockInfo == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfo;
    }

    public final Map<BlockPos, BlockInfo> getBlockInfoAsMap() {
        if (this.cacheBlockInfoMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfoMap;
    }

    public final Map<BlockPos, CompoundTag[]> getCachedEntitiesAsMap() {
        if (this.cacheEntitiesMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheEntitiesMap;
    }

    @Nullable
    public CompoundTag getTileEntityData(BlockPos worldPos, BlockPos structurePos) {
        if (!this.getBlockInfoAsMap().containsKey(structurePos) || !this.getBlockInfoAsMap().get(structurePos).hasTileEntityData()) {
            return null;
        }
        CompoundTag te = this.getBlockInfoAsMap().get(structurePos).getTileEntityData().m_6426_();
        BlockPos tePos = structurePos.m_141952_((Vec3i)worldPos);
        te.m_128405_("x", tePos.m_123341_());
        te.m_128405_("y", tePos.m_123342_());
        te.m_128405_("z", tePos.m_123343_());
        return te;
    }

    @Nullable
    public Item getItem(BlockPos pos) {
        @Nullable BlockInfo info = this.getBlockInfoAsMap().getOrDefault(pos, null);
        if (info == null || info.getState() == null || info.getState().m_60795_() || info.getState().m_60767_().m_76332_()) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(info.getState());
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack.m_41720_();
        }
        return null;
    }

    private void buildBlockInfoCaches() {
        this.cacheBlockInfo = new ArrayList<BlockInfo>(this.getVolume());
        this.cacheBlockInfoMap = new HashMap<BlockPos, BlockInfo>(this.getVolume());
        this.cacheEntitiesMap = new HashMap<BlockPos, CompoundTag[]>(this.getEntities().length);
        for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
                    BlockPos tempPos = new BlockPos((int)x, (int)y, (int)z);
                    BlockInfo blockInfo = new BlockInfo(tempPos, this.palette.get(this.structure[y][z][x] & 0xFFFF), this.tileEntities[y][z][x]);
                    this.cacheBlockInfo.add(blockInfo);
                    this.cacheBlockInfoMap.put(tempPos, blockInfo);
                    this.cacheEntitiesMap.put(tempPos, (CompoundTag[])Arrays.stream(this.getEntities()).filter(data -> data != null && this.isAtPos((CompoundTag)data, tempPos)).toArray(CompoundTag[]::new));
                }
            }
        }
    }

    public void setCachePrimaryOffset(BlockPos cachePrimaryOffset) {
        this.cachePrimaryOffset = cachePrimaryOffset;
    }

    public final BlockPos getPrimaryBlockOffset() {
        if (this.cachePrimaryOffset == null) {
            this.cachePrimaryOffset = this.findPrimaryBlockOffset();
        }
        return this.cachePrimaryOffset;
    }

    private BlockPos findPrimaryBlockOffset() {
        List<BlockInfo> list = this.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.getState().m_60734_() instanceof IAnchorBlock || blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().m_128441_("blueprintDataProvider")).toList();
        if (list.size() != 1) {
            return new BlockPos(this.getSizeX() / 2, 0, this.getSizeZ() / 2);
        }
        return list.get(0).getPos();
    }

    private void cacheReset(boolean resetPrimaryOffset) {
        this.cacheBlockInfo = null;
        if (resetPrimaryOffset) {
            this.cachePrimaryOffset = null;
        }
        this.cacheBlockInfoMap = null;
        this.cacheEntitiesMap = null;
    }

    public void rotateWithMirror(Rotation rotation, Mirror mirror, Level world) {
        BlockPos primaryOffset = this.getPrimaryBlockOffset();
        BlockPos resultSize = Blueprint.transformedSize(new BlockPos((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ), rotation);
        short newSizeX = (short)resultSize.m_123341_();
        short newSizeY = (short)resultSize.m_123342_();
        short newSizeZ = (short)resultSize.m_123343_();
        short[][][] newStructure = new short[newSizeY][newSizeZ][newSizeX];
        CompoundTag[] newEntities = new CompoundTag[this.entities.length];
        CompoundTag[][][] newTileEntities = new CompoundTag[newSizeY][newSizeZ][newSizeX];
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (int i = 0; i < this.palette.size(); ++i) {
            palette.add(i, this.palette.get(i).m_60715_(mirror).m_60717_(rotation));
        }
        BlockPos extremes = Blueprint.transformedBlockPos(this.sizeX, this.sizeY, this.sizeZ, mirror, rotation);
        int minX = extremes.m_123341_() < 0 ? -extremes.m_123341_() - 1 : 0;
        int minY = extremes.m_123342_() < 0 ? -extremes.m_123342_() - 1 : 0;
        int minZ = extremes.m_123343_() < 0 ? -extremes.m_123343_() - 1 : 0;
        this.palette = palette;
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = Blueprint.transformedBlockPos(x, y, z, mirror, rotation).m_142082_(minX, minY, minZ);
                    short value = this.structure[y][z][x];
                    BlockState state = (BlockState)palette.get(value & 0xFFFF);
                    if (state.m_60734_() == Blocks.f_50454_) continue;
                    newStructure[tempPos.m_123342_()][tempPos.m_123343_()][tempPos.m_123341_()] = value;
                    CompoundTag compound = this.tileEntities[y][z][x];
                    if (compound != null) {
                        compound.m_128405_("x", tempPos.m_123341_());
                        compound.m_128405_("y", tempPos.m_123342_());
                        compound.m_128405_("z", tempPos.m_123343_());
                        if (compound.m_128441_("blueprintDataProvider")) {
                            CompoundTag dataCompound = compound.m_128469_("blueprintDataProvider");
                            Map<BlockPos, List<String>> tagPosMap = IBlueprintDataProvider.readTagPosMapFrom(dataCompound);
                            HashMap<BlockPos, List<String>> newTagPosMap = new HashMap<BlockPos, List<String>>();
                            for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
                                newTagPosMap.put(Blueprint.transformedBlockPos(entry.getKey(), mirror, rotation), entry.getValue());
                            }
                            IBlueprintDataProvider.writeMapToCompound(dataCompound, newTagPosMap);
                            BlockPos corner1 = BlockPosUtil.readFromNBT(dataCompound, "corner1");
                            BlockPos corner2 = BlockPosUtil.readFromNBT(dataCompound, "corner2");
                            corner1 = Blueprint.transformedBlockPos(corner1, mirror, rotation);
                            corner2 = Blueprint.transformedBlockPos(corner2, mirror, rotation);
                            BlockPosUtil.writeToNBT(dataCompound, "corner1", corner1);
                            BlockPosUtil.writeToNBT(dataCompound, "corner2", corner2);
                        }
                    }
                    newTileEntities[tempPos.m_123342_()][tempPos.m_123343_()][tempPos.m_123341_()] = compound;
                }
            }
        }
        for (int i = 0; i < this.entities.length; ++i) {
            CompoundTag entitiesCompound = this.entities[i];
            if (entitiesCompound == null) continue;
            newEntities[i] = this.transformEntityInfoWithSettings(entitiesCompound, world, new BlockPos(minX, minY, minZ), rotation, mirror);
        }
        BlockPos newOffsetPos = StructureTemplate.m_74593_((BlockPos)primaryOffset, (Mirror)mirror, (Rotation)rotation, (BlockPos)new BlockPos(0, 0, 0));
        this.setCachePrimaryOffset(newOffsetPos.m_142082_(minX, minY, minZ));
        this.sizeX = newSizeX;
        this.sizeY = newSizeY;
        this.sizeZ = newSizeZ;
        this.structure = newStructure;
        this.entities = newEntities;
        this.tileEntities = newTileEntities;
        this.cacheReset(false);
    }

    public static BlockPos transformedSize(BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            }
        }
        return pos;
    }

    public static BlockPos transformedBlockPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        return Blueprint.transformedBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), mirror, rotation);
    }

    public static BlockPos transformedBlockPos(int xIn, int y, int zIn, Mirror mirror, Rotation rotation) {
        int x = xIn;
        int z = zIn;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -zIn;
                break;
            }
            case FRONT_BACK: {
                x = -xIn;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return flag ? new BlockPos(x, y, z) : new BlockPos(xIn, y, zIn);
    }

    private CompoundTag transformEntityInfoWithSettings(CompoundTag entityInfo, Level world, BlockPos pos, Rotation rotation, Mirror mirror) {
        Entity finalEntity;
        Optional type = EntityType.m_20637_((CompoundTag)entityInfo);
        if (type.isPresent() && (finalEntity = ((EntityType)type.get()).m_20615_(world)) != null) {
            try {
                Vec3 vec3;
                finalEntity.deserializeNBT(entityInfo);
                if (finalEntity instanceof HangingEntity) {
                    HangingEntity hang = (HangingEntity)finalEntity;
                    vec3 = Vec3.m_82512_((Vec3i)hang.m_31748_());
                } else {
                    vec3 = finalEntity.m_20182_();
                }
                Vec3 entityVec = Blueprint.transformedVector3d(rotation, mirror, vec3).m_82549_(Vec3.m_82528_((Vec3i)pos));
                finalEntity.m_146922_(finalEntity.m_6961_(mirror));
                finalEntity.m_146922_(finalEntity.m_7890_(rotation));
                finalEntity.m_7678_(entityVec.f_82479_, entityVec.f_82480_, entityVec.f_82481_, finalEntity.m_146908_(), finalEntity.m_146909_());
                return finalEntity.serializeNBT();
            }
            catch (Exception ex) {
                Log.getLogger().error("Entity: " + ((EntityType)type.get()).m_20675_() + " failed to load. ", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private static Vec3 transformedVector3d(Rotation rotation, Mirror mirror, Vec3 vec) {
        double xCoord = vec.f_82479_;
        double zCoord = vec.f_82481_;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3(zCoord, vec.f_82480_, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3(1.0 - zCoord, vec.f_82480_, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3(1.0 - xCoord, vec.f_82480_, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3(xCoord, vec.f_82480_, zCoord) : vec;
    }

    private int getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.palleteSize;
        result = 31 * result + this.getVolume();
        result = 31 * result + this.renderSource.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return this.name.equals(other.name) && this.palleteSize == other.palleteSize && this.getVolume() == other.getVolume();
    }

    public void setRenderSource(BlockPos pos) {
        this.renderSource = pos;
    }

    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos pos, boolean includeEntities) {
        return new BlueprintPositionInfo(pos, this.getBlockInfoAsMap().get(pos), includeEntities ? this.getCachedEntitiesAsMap().getOrDefault(pos, new CompoundTag[0]) : new CompoundTag[]{});
    }

    private boolean isAtPos(CompoundTag entityData, BlockPos pos) {
        ListTag list = entityData.m_128437_(ENTITY_POS, 6);
        int x = (int)list.m_128772_(0);
        int y = (int)list.m_128772_(1);
        int z = (int)list.m_128772_(2);
        return new BlockPos(x, y, z).equals((Object)pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockInfoAsMap().get(pos).getState();
    }
}

